const desktopBreakpoint = window.matchMedia('(min-width:1230px)');
const tabletBreakpoint = window.matchMedia('(max-width:1149px)');
const mobileBreakpoint = window.matchMedia('(max-width:749px)');
const noTouchDevices = window.matchMedia('(hover:hover)');

$(document).ready(function () {
  const desktopBreakpointChecker = function () {
    if (desktopBreakpoint.matches) {

    } else {

    }
  };

  const tabletBreakpointChecker = function () {
    if (tabletBreakpoint.matches) {
      if ($('.openSiteMenu, .openCabinetMenu').hasClass('active')) {
        $('html, body').addClass('menuIsOpened');
      }
    } else {
      if ($('html, body').hasClass('menuIsOpened')) {
        $('html, body').removeClass('menuIsOpened');
      }

      if ($('.topicContent').length > 0) {
        $('.topicContent').map(function () {
          $(this).attr('style', '')
        })
      }
    }
  };

  const mobileBreakpointChecker = function () {
    if (mobileBreakpoint.matches) {
      if ($('.cabinetNav').length > 0) {
      }
    } else {
    }
  };

  const touchDevicesChecker = function () { };

  desktopBreakpoint.addEventListener('change', desktopBreakpointChecker);
  tabletBreakpoint.addEventListener('change', tabletBreakpointChecker);
  mobileBreakpoint.addEventListener('change', mobileBreakpointChecker);
  noTouchDevices.addEventListener('change', touchDevicesChecker)

  desktopBreakpointChecker();
  tabletBreakpointChecker();
  mobileBreakpointChecker();
  touchDevicesChecker();

  if ($('.themeControl').length > 0) {
    $('.themeControl').not('.off').on('click', function () {
      $('body').toggleClass('darkTheme');
      $(this).toggleClass('invert');
    })
  }

  if ($('.langList').length > 0) {
    $('.langList').find('.head').on('click', function () {
      $(this).toggleClass('active');
      $(this).siblings().stop().slideToggle(300);
    })

    $(document).mouseup(function (e) {
      if ($('.langList .head').hasClass('active')) {
        let content = $('.langList');

        if (!content.is(e.target) && content.has(e.target).length === 0) {
          content.find('.head').removeClass('active');
          content.find('.list').stop().slideUp();
        }
      }
    });
  }

  if ($('.siteTabs').length > 0) {
    $('.siteTabs').map(function () {
      $(this)
        .children('.tabsList')
        .children('.tab')
        .map(function (index) {
          $(this).on('click', function (event) {
            event.preventDefault();

            let el = $(this),
              tabs = el.parents('.siteTabs').first(),
              tabContent = tabs.children('.tabContentWrapper').children('.tabContent').eq(index);
            let swiper = tabContent.find('.swiper');
            let faq = tabContent.children('.topicTab');

            history.pushState({}, '', el.find('a').attr('href'));

            if (!$(this).hasClass('active')) {
              el.addClass('active').siblings('.tab').removeClass('active')
              tabContent
                .addClass('active')
                .siblings('.tabContent')
                .removeClass('active')

              if (faq) {
                faq.addClass('active');
                tabContent.siblings().children('.topicTab').removeClass("active");
                tabContent.siblings().children('.topicContent').attr('style', '');
              }
            }
          })

          let href = $(this).find('a').attr('href');

          if (href === window.location.hash) {
            $(this).find('a').trigger('click')
          }

          // if (swiper.length > 0) {
          //   swiper.get(0).swiper.update()
          // }
        })
    })
  }

  if ($('.topicTab').length > 0) {
    $('.siteTabs').map(function () {
      let topicTabs = $(this).children('.tabContentWrapper').children('.tabContent').children('.topicTab');

      topicTabs.map(function (index) {
        let el = $(this),
          tabs = el.parents('.siteTabs').first(),
          tab = tabs.find('.tab').eq(index),
          tabContent = tabs.children('.tabContentWrapper').children('.tabContent').eq(index),
          siblingTabs = tabContent.siblings().children('.topicTab');

        el.on('click', function () {
          if (el.hasClass('active')) {
            el.siblings().stop().slideUp(500, function () {
              el.removeClass('active');
            });
            return false
          } else {
            el.siblings().stop().slideDown(500, function () {
              el.addClass('active');
            });

            siblingTabs.siblings().stop().slideUp(500, function () {
              siblingTabs.removeClass('active');
            });

            if (tab) {
              tab.addClass('active').siblings().removeClass('active');
              tabContent.addClass('active').siblings().removeClass('active');
            }
          }
        })
      })
    })
  }

  if ($('.copyLink').length > 0) {
    $(".copyLink").map(function () {
      var btn = $(this)
      var clipboard = new ClipboardJS(btn[0])

      btn.on('click', function (e) {
        e.preventDefault()
      })

      if (btn.parents('.copyContainer').length > 0) {
        clipboard.on('success', function (event) {
          event.clearSelection()
          btn.parents('.copyContainer').find('.copyMessage').addClass('active')
          setTimeout(function () {
            btn.parents('.copyContainer').find('.copyMessage').removeClass('active')
          }, 2000)
        });
      }
    })
  }

  if ($('.enterNum').length > 0) {
    $('.enterNum').map(function () {
      $(this).bind('change keyup input click', function () {
        if (this.value.match(/[^0-9.]/g)) {
          this.value = this.value.replace(/[^0-9.]/g, '');
        }
      });
    })
  }

  if ($('.faqItem, .dropdownItem').length > 0) {
    let dropHead = $('.faqItem > .head, .dropdownItem > .head'),
      dropContent = $('.faqItem > .content, .dropdownItem > .content');

    $('.faqItem, .dropdownItem').map(function () {
      let el = $(this);
      if (el.children('.head').length > 0 && el.children('.content').length > 0) {

        el.children('.head').on('click', function (e) {
          e.stopPropagation()
          let el = $(this),
            cont = el.siblings(dropContent),
            parent = el.closest('.faqItem, .dropdownItem');

          if (parent.hasClass('active')) {
            cont.stop().slideUp(500, function () {
              parent.removeClass('active');
            });
          } else {
            cont.stop().slideDown(300);
            parent.addClass('active');
          }
        })
      }
    })
  }

  if ($('.cabTimer').length > 0) {
    $('.cabTimer').map(timer)
  }

  if ($('.tooltipControl').length > 0) {
    $('.tooltipControl').map(function () {
      $(this).on('click', function (e) {
        e.stopPropagation()
      })
      $(this).tooltipster({
        functionBefore: function (instance, helper) {
          let content = $(helper.origin).siblings('.tooltipContent');
          instance.content(content);
        },
        functionReady: function (instance, helper) {
          $(helper.origin).addClass('active')
        },
        functionAfter: function (instance, helper) {
          $(helper.origin).removeClass('active')
        },
        content: $(this).siblings('.tooltipContent'),
        trigger: noTouchDevices.matches ? 'hover' : 'click',
        distance: -25,
        zIndex: 100,
        animationDuration: [300, 100],
        contentCloning: true,
        positionTracker: true,
      });
    })
  }

  if ($('select').length > 0) {
    $('select').map(function () {
      let el = $(this);
      if (el.hasClass('payment')) {
        el.selectric({
          labelBuilder: function (item) {
            let icon = $(item.element).attr('data-icon'),
              sum = $(item.element).attr('data-sum'),
              cur = $(item.element).attr('data-cur');
            return `<span class="selectLabel">
            <span class="icon">
              <img src="${icon}" alt="icon">
            </span>
            <span class="text">
              ${item.text}
              <span class="sum"></span>
            </span>
            </span>`
          },
          optionsItemBuilder: function (item) {
            let icon = $(item.element).attr('data-icon'),
              sum = $(item.element).attr('data-sum'),
              cur = $(item.element).attr('data-cur');
            return `<span class="selectLabel">
            <span class="icon">
              <img src="${icon}" alt="icon">
            </span>
            <span class="text">
              ${item.text}
              <span class="sum"></span>
            </span>
            </span>`
          },
          arrowButtonMarkup: '<span class="button"><img src="'+bundle+'/img/select_arrow.svg" alt="arrow"></span>',
          disableOnMobile: false,
          nativeOnMobile: false,
          onChange: function(element, select) {
              let index = select.state.selectedIdx;
              $(this).parents('.paymentsList').find('input[type="radio"]').eq(index).prop('checked', true).change();
          },
        }
        )
      } else {
        el.selectric({
          arrowButtonMarkup: '<span class="button"><img src="'+bundle+'/img/select_arrow.svg" alt="arrow"></span>',
        })
      }
    })
  }

  if ($('.paymentsList').length > 0) {
    $('.paymentsList').map(function () {
      let el = $(this),
        select = el.find('select');

      el.find('input[type="radio"]').map(function (index) {
        let radio = $(this);

        if (radio.prop('checked') === true) {
          select.prop('selectedIndex', index).selectric('refresh');
        }

        radio.on('change', function () {
          select.prop('selectedIndex', index).selectric('refresh');
        })
      })
    })
  }

  if ($('.setDate').length > 0) {
    $('.setDate').map(function () {
      $(this).off();
      $(this).datepicker({
        dateFormat: 'dd.mm.yy',
        beforeShow: function () {
          $(this).siblings('img').addClass("active");
          $(this).siblings('label').removeClass('inactive')
        },
        onClose: function () {
          $(this).siblings('img').removeClass("active");
          if (!$(this).val()) {
            $(this).siblings('label').addClass('inactive')
          }
        },
        // showOn: 'button',
        // buttonImage: 'img/select_arrow.svg',
        // buttonImageOnly: true
      })
    })
  }

  if ($('.mainAboutSlider').length > 0) {
    let mainAboutSlider = new Swiper('.mainAboutSlider', {
      slidesPerView: 2,
      slidesPerGroup: 2,
      spaceBetween: 117,
      navigation: {
        nextEl: '.mainAboutSlider .swiper-button-next',
        prevEl: '.mainAboutSlider .swiper-button-prev',
      },
      pagination: {
        el: '.mainAboutSlider .swiper-pagination',
        clickable: true
      },
      a11y: {
        enabled: false,
      },
      autoplay: {
        delay: 4000,
        pauseOnMouseEnter: true,
        disableOnInteraction: false
      },
      breakpoints: {
        0: {
          slidesPerView: 1,
          slidesPerGroup: 1,
          spaceBetween: 20,
        },
        750: {
          slidesPerView: 2,
          slidesPerGroup: 2,
          spaceBetween: 40,
        },
        1016: {
          slidesPerView: 2,
          slidesPerGroup: 2,
          spaceBetween: 95,
        },
        1230: {
          slidesPerView: 2,
          slidesPerGroup: 2,
          spaceBetween: 117
        }
      }
    });
  }

  if ($('.roadmapSlider').length > 0) {
    let roadmapSlider = new Swiper('.roadmapSlider', {
      slidesPerView: 3,
      slidesPerGroup: 3,
      spaceBetween: 48,
      navigation: {
        nextEl: '.roadmapSlider .swiper-button-next',
        prevEl: '.roadmapSlider .swiper-button-prev',
      },
      a11y: {
        enabled: false,
      },
      pagination: {
        el: '.roadmapSlider .swiper-pagination',
        clickable: true
      },
      breakpoints: {
        0: {
          slidesPerView: 'auto',
          slidesPerGroup: 1,
          spaceBetween: 20,
        },
        1016: {
          slidesPerView: 3,
          slidesPerGroup: 3,
          spaceBetween: 40,
        },
        1230: {
          slidesPerView: 3,
          slidesPerGroup: 3,
          spaceBetween: 48,
        },
      }
    });
  }

  if ($('.stepsList').length > 0) {
    let stepsList = new Swiper('.stepsList', {
      slidesPerView: 'auto',
      enabled: false,
      navigation: {
        nextEl: '.stepsList .swiper-button-next',
        prevEl: '.stepsList .swiper-button-prev',
      },
      a11y: {
        enabled: false,
      },
      breakpoints: {
        0: {
          slidesPerView: 'auto',
          spaceBetween: 20,
          enabled: true,
        },
        768: {
          enabled: false,
        },
      }
    });
  }

  if ($('.dashboardProfitSlider').length > 0) {
    let stepsList = new Swiper('.dashboardProfitSlider', {
      slidesPerView: 4,
      spaceBetween: 40,
      enabled: false,
      navigation: {
        nextEl: '.dashboardProfitSlider .swiper-button-next',
        prevEl: '.dashboardProfitSlider .swiper-button-prev',
      },
      a11y: {
        enabled: false,
      },
      breakpoints: {
        0: {
          slidesPerView: 'auto',
          spaceBetween: 14,
          enabled: true,
        },
        1150: {
          slidesPerView: 3,
          spaceBetween: 13,
          enabled: false,
        },

        1830: {
          slidesPerView: 4,
          spaceBetween: 30,
          enabled: false,
        },
      }
    });
  }

  if ($('.depositSlider').length > 0) {
    $('.depositSlider').map(function () {
      let el = $(this);
      let pagination = el.hasClass('ver2') ? {
        el: el.find('.swiper-pagination').get(0),
        clickable: true,
        renderBullet: function (index, className) {
          return '<span class="' + className + '">' + (index + 1) + "</span>";
        }
      } : {
        el: el.find('.swiper-pagination').get(0),
        clickable: true,
      };
      let depositSlider = new Swiper(el.get(0), {
        slidesPerView: 3,
        spaceBetween: el.hasClass('ver2') ? 39 : 73,
        navigation: {
          nextEl: el.find('.swiper-button-next').get(0),
          prevEl: el.find('.swiper-button-prev').get(0),
        },
        a11y: {
          enabled: false,
        },
        pagination: pagination,
        breakpoints: {
          0: {
            slidesPerView: 'auto',
            spaceBetween: 10,
          },
          1150: {
            slidesPerView: 2,
            spaceBetween: el.hasClass('ver2') ? 17 : 38,
          },
          1366: {
            slidesPerView: 2,
            spaceBetween: el.hasClass('ver2') ? 49 : 63,
          },
          1830: {
            slidesPerView: 3,
            spaceBetween: el.hasClass('ver2') ? 39 : 73,
          },
        }
      });
    })
  }

  if ($('.tableSlider').length > 0) {
    $('.tableSlider').map(function () {
      let el = $(this);
      let tableSlider = new Swiper(el.get(0), {
        slidesPerView: 'auto',
        spaceBetween: 12,
        navigation: {
          nextEl: el.find('.swiper-button-next').get(0),
          prevEl: el.find('.swiper-button-prev').get(0),
        },
        enabled: false,
        a11y: {
          enabled: false,
        },
        breakpoints: {
          0: {
            slidesPerView: 'auto',
            spaceBetween: 12,
            enabled: true,
          },
          1150: {
            spaceBetween: 0,
            enabled: false,
          }
        }
      });
    })
  }
  if ($('.tableSlider2').length > 0) {
    $('.tableSlider2').map(function () {
      let el = $(this);
      let tableSlider = new Swiper(el.get(0), {
        slidesPerView: 'auto',
        spaceBetween: 20,
        navigation: {
          nextEl: el.find('.swiper-button-next').get(0),
          prevEl: el.find('.swiper-button-prev').get(0),
        },
        enabled: false,
        a11y: {
          enabled: false,
        },
        breakpoints: {
          0: {
            slidesPerView: 1,
            spaceBetween: 12,
            enabled: true,
          },
          400: {
            slidesPerView: 'auto',
            spaceBetween: 12,
            enabled: true,
          },
          1150: {
            spaceBetween: 0,
            enabled: false,
          }
        }
      });
    })
  }
  if ($('.linesSider').length > 0) {
    $('.linesSider').map(function () {
      let el = $(this);
      let linesSider = new Swiper(el.get(0), {
        slidesPerView: 'auto',
        spaceBetween: 20,
        navigation: {
          nextEl: el.find('.swiper-button-next').get(0),
          prevEl: el.find('.swiper-button-prev').get(0),
        },
        enabled: false,
        a11y: {
          enabled: false,
        },
        breakpoints: {
          0: {
            slidesPerView: 1,
            spaceBetween: 15,
            enabled: true,
          },
          750: {
            slidesPerView: 'auto',
            spaceBetween: 13,
            enabled: true,
          },
          1150: {
            spaceBetween: 0,
            enabled: false,
          }
        }
      });
    })
  }
  if ($('.refList').length > 0) {
    // $('.refList').map(function () {
    //   let el = $(this);
    //   let linesSider = new Swiper(el.get(0), {
    //     slidesPerView: 'auto',
    //     spaceBetween: 20,
    //     navigation: {
    //       nextEl: el.find('.swiper-button-next').get(0),
    //       prevEl: el.find('.swiper-button-prev').get(0),
    //     },
    //     enabled: false,
    //     a11y: {
    //       enabled: false,
    //     },
    //     breakpoints: {
    //       0: {
    //         slidesPerView: 1,
    //         spaceBetween: 15,
    //         enabled: true,
    //       },
    //       750: {
    //         slidesPerView: 'auto',
    //         spaceBetween: 12,
    //         enabled: true,
    //       },
    //       1150: {
    //         spaceBetween: 0,
    //         enabled: false,
    //       }
    //     }
    //   });
    // })
  }

  if ($('.openSiteMenu').length > 0) {
    $('.openSiteMenu').on('click', function () {
      if ($(this).hasClass('active')) {
        $('.mobileMenu').stop().fadeOut(300);
        $(this).removeClass('active');
        $('html, body').removeClass('menuIsOpened')
      } else {
        $('.mobileMenu').stop().fadeIn(300);
        $(this).addClass('active');
        $('html, body').addClass('menuIsOpened')
      }
    })
  }

  if ($('.openCabinetMenu').length > 0) {
    $('.openCabinetMenu').on('click', function () {
      if ($(this).hasClass('active')) {
        $('.mobileCabMenu').stop().fadeOut(300);
        $(this).removeClass('active');
        $('html, body').removeClass('menuIsOpened')
      } else {
        $('.mobileCabMenu').stop().fadeIn(300);
        $(this).addClass('active');
        $('html, body').addClass('menuIsOpened')
      }
    })
  }

  if ($('.fileBtn').length > 0) {
    $('.fileBtn').map(function () {
      let button = $(this),
        input = button.find('input'),
        label = button.find('.fileName'),
        filesList = [];

      input.on('change', function (e) {
        let el = $(this),
          files = filesList.concat(Array.prototype.slice.call(e.target.files)),
          dt = new DataTransfer();

        filesList = files;

        if (e.target.files.length > 0) {
          files.map(function (item) {
            dt.items.add(item)
          })

          files.forEach(function (item, index) {
            let name = item.name;

            label.text(name)
          })

          e.target.files = dt.files;
        }
      })
    })
  }

  if ($('.cabDate, .cabTime').length > 0) {
    $('.cabClock').map(function() {
      let el = $(this),
          timeEl = el.find('.cabTime'),
          dateEl = el.find('.cabDate')
      function clock() {
        var date = new Date(),
            day = date.getDate(),
            weekDays = dateEl.attr('data-days').split(','),
            weekDay = weekDays[date.getDay()],
            month = date.getMonth(),
            monthArr = dateEl.attr('data-months').split(','),
            year = date.getFullYear(),
            hour = date.getHours(),
            min = date.getMinutes(),
            sec = date.getSeconds();

        if (hour < 10) hour = '0' + hour;
        if (min < 10) min = '0' + min;
        if (sec < 10) sec = '0' + sec;

        dateEl.html(day + ' ' + monthArr[month] + ', ' + weekDay);
        timeEl.html(hour + ' : ' + min + ' : ' + sec);
      }

      function clockStart() {
        setInterval(clock, 1000);
      }

      clockStart();
    })
  }

  if ($('.circularChart').length > 0) {
    $('.circularChart').map(function (index) {
      let mask = $(this).find('mask'),
        rect = $(this).children('rect');

      mask.attr('id', `m${index}`);
      rect.attr('mask', `url(#m${index})`);
    })
  }

  if ($('.modalsScroll').length > 0) {
    openMod();
  }

  if ($('.openBalanceTable').length > 0) {
    $('.openBalanceTable').on('click', function () {
      $(this).siblings('.cabBalanceTable').stop().slideToggle(300);
      $(this).toggleClass('active');
    })
  }

  if ($('.animatedVr').length > 0) {
    TweenMax.set("#ring1, #ring2,\
    #ring2 .c4, #ring2 .c5, #ring2 .c6, #ring2 .c7,\
    #ring2-1, #ring3,\
    #ring3-1, #ring3 .c4,\
    #ring4, #ring4 .c1, #ring4 .c2,\
    #ring4 .c3, #ring4 .c4", { transformOrigin: "50% 50%" })

    function pad(num, size) {
      var s = num + "";
      while (s.length < size) s = "0" + s;
      return s;
    }

    TweenMax.set("#ring1 .c1", { drawSVG: "0% 25%" })
    TweenMax.set("#ring1 .c2", { drawSVG: "50% 75%" })

    TweenMax.set("#ring2 .c4", { drawSVG: "0% 0%" })
    TweenMax.set("#ring2 .c5", { drawSVG: "0% 0%" })
    TweenMax.set("#ring2 .c6", { drawSVG: "0% 0%" })
    TweenMax.set("#ring2 .c7", { drawSVG: "0% 0%" })

    TweenMax.set("#ring3 .c1", { drawSVG: "0% 25%" })
    TweenMax.set("#ring3 .c2", { drawSVG: "50% 75%" })
    TweenMax.set("#ring3 .c4", { drawSVG: "60%" })

    TweenMax.set("#ring4 .c1", { drawSVG: "60%", rotation: 120 })
    TweenMax.set("#ring4 .c2", { drawSVG: "60%", rotation: 40 })
    TweenMax.set("#ring4 .c3", { drawSVG: "60%", rotation: 180 })

    var u = 0.75

    TweenMax.to("#ring1", 60 * u, { rotation: -360, repeat: -1, ease: Linear.easeNone })
    TweenMax.to("#ring2-1", 120 * u, { rotation: 360, repeat: -1, ease: Linear.easeNone })
    TweenMax.to("#ring2 .c4", 10 * u, { rotation: 360, repeat: -1, ease: Linear.easeNone })
    TweenMax.to("#ring2 .c5", 10 * u, { rotation: 360, repeat: -1, ease: Linear.easeNone })
    TweenMax.to("#ring2 .c6", 10 * u, { rotation: 360, repeat: -1, ease: Linear.easeNone })
    TweenMax.to("#ring2 .c7", 10 * u, { rotation: 360, repeat: -1, ease: Linear.easeNone })
    TweenMax.to("#ring3-1", 30 * u, { rotation: 360, repeat: -1, ease: Linear.easeNone })
    TweenMax.to("#ring3 .c4", 10 * u, { rotation: -360, repeat: -1, ease: Linear.easeNone })
    TweenMax.to("#ring4 .c1", 5 * u, { rotation: 360 + 120, repeat: -1, ease: Linear.easeNone })
    TweenMax.to("#ring4 .c2", 10 * u, { rotation: -360 + 40, repeat: -1, ease: Linear.easeNone })
    TweenMax.to("#ring4 .c3", 2 * u, { rotation: 360 + 180, repeat: -1, ease: Linear.easeNone })
    TweenMax.to("#ring4 .c4", 2 * u, { scale: 1.15, yoyo: true, repeat: -1, ease: Power2.easeInOut })

    var timeout
    document.body.addEventListener("mousemove", move)
    document.body.addEventListener("touchmove", move)

    function move(e) {
      e.preventDefault()
      clearTimeout(timeout)
      TweenMax.to("#move-text", 1, { opacity: 0 })
      var px = e.clientX
      var py = e.clientY
      if (e.touches) {
        px = e.touches[0].clientX
        py = e.touches[0].clientY
      }
      var w = window.innerWidth / 2
      var h = window.innerHeight / 2
      var nx = (px - w) / w
      var ny = (py - h) / h

      var tx = nx * 150
      var ty = ny * 60

      animCircles(tx, ty)
      timeout = setTimeout(function () {
        animCircles(0, 0)
      }, 2000)
    }

    function animCircles(tx, ty) {
      var tl = new TimelineMax()
      var rf = [1, 0.5, 0.25, 0.125]
      for (var i = 1; i < 5; i++) {
        tl.to("#ring" + i, 2.5, { x: tx * rf[i], y: ty * rf[i - 1] }, "a")
      }
    }

    var diskTotal = 423
    var diskMax = 2048
    var energyMax = 50
    var bandwidthMax = 32
    var timeMax = 2400

    function updateData() {
      var time = new Date()
      var timeValue = pad(time.getHours() * 100 + time.getMinutes(), 4)
      var tp = timeValue / timeMax * 100
      document.getElementById("time-text").textContent = timeValue + "HRS"
      TweenMax.to("#ring2 .c4", 0.5, { drawSVG: "0% " + tp + "%" })

      var energy = Math.floor(Math.random() * 30 + 10)
      var ep = energy / energyMax * 100
      document.getElementById("energy-text").textContent = energy + "W"
      TweenMax.to("#ring2 .c5", 0.5, { drawSVG: "0% " + ep + "%" })

      var bandwidth = Math.floor(Math.random() * 20 + 5)
      var dp = bandwidth / bandwidthMax * 100
      document.getElementById("bandwidth-text").textContent = bandwidth + "Mbps"
      TweenMax.to("#ring2 .c6", 0.5, { drawSVG: "0% " + dp + "%" })

      diskTotal = Math.floor(diskTotal * 10 + 1) / 10
      diskTotal = diskTotal > diskMax ? 423 : diskTotal
      var dip = diskTotal / diskMax * 100
      document.getElementById("disk-text").textContent = diskTotal + "GB"
      TweenMax.to("#ring2 .c7", 0.5, { drawSVG: "0% " + dip + "%" })

      setTimeout(updateData, 2000)
    }
    updateData()
  }
});

if (document.querySelector(".hero-banner")) {
  const particleWave = () => {
    const heroBanner = document.querySelector(".hero-banner");
    let w = heroBanner.clientWidth;
    let h = heroBanner.clientHeight;
    const dpr = window.devicePixelRatio;

    const fov = 60;
    const fovRad = fov * (Math.PI / 180);
    const dist = h / 2 / Math.tan(fovRad);

    const clock = new THREE.Clock();
    const pointSize = 4 * dpr;

    const renderer = new THREE.WebGLRenderer({ alpha: true });
    renderer.setSize(w, h);
    renderer.setClearColor( 0x000000, 0 );
    renderer.setPixelRatio(dpr);

    const container = document.getElementById("webgl-canvas");
    container.appendChild(renderer.domElement);

    const camera = new THREE.PerspectiveCamera(fov, w / h, 1, dist * 8);
    camera.position.x = 0;
    camera.position.y = 20;
    camera.position.z = 150;

    const scene = new THREE.Scene();

    // TODO: This fog isn't working for some reason
    const fogColor = "#fff"; // white
    const near = 1.8;
    const far = 2;
    scene.fog = new THREE.Fog(fogColor, near, far);
    scene.background = null;

    const geo = new THREE.BufferGeometry();
    const positions = [];

    const width = 200 * (w / h);
    const depth = 100;
    const distance = 5;

    for (let x = 0; x < width; x += distance) {
      for (let z = 0; z < depth; z += distance) {
        positions.push(-width / 2 + x, -30, -depth / 2 + z);
      }
    }
    const positionAttribute = new THREE.Float32BufferAttribute(positions, 3);
    geo.setAttribute("position", positionAttribute);

    const mat = new THREE.ShaderMaterial({
      uniforms: {
        u_time: {
          value: 0.0
        },
        color1: {
          value: new THREE.Color("#147197")
        },
        color2: {
          value: new THREE.Color("#1c6ab2")
        },
        color3: {
          value: new THREE.Color("#2055af")
        },
        color4: {
          value: new THREE.Color("#8236c4")
        },
        color5: {
          value: new THREE.Color("#a92ccf")
        },
        resolution: { type: "v2", value: new THREE.Vector2(w * dpr, h * dpr) },
        pointSize: { value: pointSize }
      },
      vertexShader: `
          precision highp float;
          #define M_PI 3.1415926535897932384626433832795
          
          uniform float u_time;
          uniform float pointSize;
          
          void main() {
            vec3 p = position;
            p.y += (
               cos(p.x / M_PI * 8.0 + u_time * 1.5) * 15.0 +
               sin(p.z / M_PI * 8.0 + u_time * 1.5) * 15.0 + 
               60.0
             ) ;
            
            gl_PointSize = pointSize;
            gl_Position = projectionMatrix * modelViewMatrix * vec4(p, 1.0);
          }   
      
      `,
      fragmentShader: `
          precision highp float;
          
          uniform vec3 color1;
          uniform vec3 color2;
          uniform vec3 color3;
          uniform vec3 color4;
          uniform vec3 color5;
          uniform vec2 resolution;
          
          void main() {
            // create circles instead of squares
            if ( length( gl_PointCoord - vec2( 0.5, 0.5 ) ) > 0.475 ) discard;
            
            float x = gl_FragCoord.x;
            float step1 = 0.25;
            float step2 = 0.45;
            float step3 = 0.55;
            float step4 = 0.75;
            float step5 = 1.00;
            
                  
            float mixValue = x / resolution.x;
            
            // create color stops using 'mix', and convert the progress through each 'step'
            // to a value between 0 and 1
            vec3 mixedColor;
            if(mixValue < step1) {
              mixedColor = mix(color1, color2, mixValue / step1);
            } else if (mixValue >= step1 && mixValue < step2) {
              mixedColor = mix(color2, color3, ((mixValue - step1) / (step2 - step1)));
            } else if (mixValue >= step2 && mixValue < step3) {
              mixedColor = color3;
            } else if (mixValue >= step3 && mixValue < step4) {
              mixedColor = mix(color3, color4, ((mixValue - step3) / (step4 - step3)));
            } else {
              mixedColor = mix(color4, color5, ((mixValue - step4) / (step5 - step4)));
            }
            
            gl_FragColor = vec4(mixedColor, 1.0);
          }
      `
    });

    const mesh = new THREE.Points(geo, mat);
    scene.add(mesh);

    function render() {
      const time = clock.getElapsedTime();
      mesh.material.uniforms.u_time.value = time;
      renderer.render(scene, camera);
      requestAnimationFrame(render);
    }
    render();

    function onWindowResize() {
      w = heroBanner.clientWidth;
      h = heroBanner.clientHeight;
      camera.aspect = w / h;
      camera.updateProjectionMatrix();
      renderer.setSize(w, h);
    }
    window.addEventListener("resize", onWindowResize);
  };

  window.addEventListener("load", particleWave);
}

$(window).on('load', function () {

  if ($(".chartBlock").length > 0) {
    let chartOptions = {
      chart: {
        borderColor: '#3f3f3f10',
        backgroundColor: 'transparent',
        type: 'areaspline',
        style: {
          fontFamily: 'Roboto'
        },
        margin: [0, 0, 0, 0],
        borderColor: '#404a60',
        borderRadius: 0,
        borderWidth: 1,
      },
      title: {
        text: ''
      },
      subtitle: {
        text: ''
      },
      xAxis: {
        title: {
          text: ''
        },
        categories: ['Янв', 'Фев', 'Мар', 'Апр', 'Май', 'Июн', 'Июл', 'Авн', 'Сен', 'Окт', 'Ноя', 'Дек'],
        lineColor: '#404a60',
        gridLineColor: '#404a60',
        minorGridLineColor: '#404a60',
        minorGridLineWidth: 1,
        minorTickLength: 0,
        tickLength: 0,
        minorTickInterval: 1,
        labels: {
          enabled: false,
        },
      },
      yAxis: {
        title: {
          text: ''
        },
        labels: {
          enabled: false,
          style: {
            color: '#3f3f3f',
            fontSize: '14px'
          }
        },
        lineColor: '#404a60',
        lineWidth: 1,
        gridLineColor: '#404a60',
        min: 0.055,
        tickInterval: 0.005
      },
      tooltip: {
        enabled: false,
      },
      plotOptions: {
        series: {
          marker: {
            enabled: false,
          },
          fillOpacity: 0.1,
          fillColor: '#00000020'
        }
      },
      colors: ['#cd9e36'],
      legend: {
        enabled: false
      },
      series: [{
        color: {
          linearGradient: { x1: 0, x2: 0, y1: 0, y2: 1 },
          stops: [
            [0, '#9078e2'],
            [1, '#259ae7']
          ]
        },
        lineWidth: 2,
        data: [
          { y: 1000, category: 'Январь' },
          { y: 2000, category: 'Февраль' },
          { y: 3000, category: 'Март' },
          { y: 4000, category: 'Апрель' },
          { y: 5000, category: 'Май' },
          { y: 5500, category: 'Июнь' },
          { y: 6000, category: 'Июль' },
          { y: 7000, category: 'Август' },
          { y: 7500, category: 'Сентябрь' },
          { y: 8000, category: 'Октябрь' },
          { y: 9000, category: 'Ноябрь' },
          { y: 10000, category: 'Декабрь' }
        ]
      }],
      credits: {
        enabled: false
      },
    }

    let graficCurrents1 = Highcharts.chart('chart1', chartOptions),
      graficCurrents2 = Highcharts.chart('chart2', chartOptions),
      graficCurrents3 = Highcharts.chart('chart3', chartOptions);
  }

  if ($('.btnUp').length > 0) {
    $(window).on('scroll', function () {
      if ($(this).scrollTop() > $(window).height() / 2) {
        $('.btnUp').addClass('visible')
      } else {
        $('.btnUp').removeClass('visible')
      }
    });

    $('.btnUp').on('click', function () {
      $('html, body').animate({
        scrollTop: 0
      }, 300);
    })
  }

  if ($('.expandCabinetMenu').length > 0) {
    $('.cabinetMainMenu').css({ 'overflow': 'hidden' });
    $('.expandCabinetMenu').on('click', function () {
      let menu = $(this).siblings('.cabinetMainMenu'),
        defaultHeight = menu.parents('.cabinetHeader').innerHeight(),
        fullHeight = menu.find('.cabMenu').innerHeight(),
        timerId;
      clearTimeout(timerId);

      if ($(this).hasClass('active')) {
        menu.height(defaultHeight);
        $(this).removeClass('active');
        menu.removeClass('active');
        timerId = setTimeout(() => menu.css({ 'overflow': 'hidden' }), 300);
      } else {
        menu.height(fullHeight);
        $(this).addClass('active');
        menu.addClass('active');
        menu.css({ 'overflow': 'visible' });
      }
    })
  }

  if ($('.openCabinetStat').length > 0) {
    $('.openCabinetStat').on('click', function () {
      $(this).siblings().toggleClass('active');
      $(this).toggleClass('active');
    })
  }
});

// cabinet timer start
let m
const timer = function () {
  let now = new Date($(this).attr('data-now')),
    startTime = new Date($(this).attr('data-start')),
    finishTime = new Date($(this).attr('data-end')),
    startMS = startTime.getTime(),
    finishMS = finishTime.getTime(),
    nowMS = now.getTime(),
    betweenMS = finishMS - startMS,
    lastMS = finishMS - nowMS,
    percent = lastMS * 100 / betweenMS,
    lastDay,
    lastHour,
    lastMin,
    lastSec;
  percent = 100 - percent.toFixed();

  m = setInterval(function () {
    nowMS = nowMS + 1000;
    lastMS = finishMS - nowMS;

    lastSec = Math.floor((lastMS / 1000) % 60);
    lastMin = Math.floor((lastMS / 1000 / 60) % 60);
    lastHour = Math.floor((lastMS / (1000 * 60 * 60)) % 24);
    lastDay = Math.floor(lastMS / (1000 * 60 * 60 * 24));

    lastDay = checkTime(lastDay);
    lastHour = checkTime(lastHour);
    lastMin = checkTime(lastMin);
    lastSec = checkTime(lastSec);

    $(this).html(`${lastDay}:${lastHour}:${lastMin}:${lastSec}`)

    if (lastMS / 1000 < 0) {
      $(this).html(`00:00:00:00`)
    }

  }.bind(this), 1000)
};

const checkTime = function (i) {
  if (i < 10) {
    i = '0' + i;
  }
  return i;
}
// cabinet timer end