{include file="header.tpl"}
<div class="page-header mb-3">
<h2 class="page-title fs-2r">
<svg class="me-2" width="34px" height="34px" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <path d="M22 12C22 16.714 22 19.0711 20.5355 20.5355C19.0711 22 16.714 22 12 22C7.28595 22 4.92893 22 3.46447 20.5355C2 19.0711 2 16.714 2 12C2 7.28595 2 4.92893 3.46447 3.46447C4.92893 2 7.28595 2 12 2" stroke="#4263EB" stroke-width="2" stroke-linecap="round"></path> <path d="M13 7L15 9L20 4" stroke="#4263EB" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path> <path d="M2 12.5001L3.75159 10.9675C4.66286 10.1702 6.03628 10.2159 6.89249 11.0721L11.1822 15.3618C11.8694 16.0491 12.9512 16.1428 13.7464 15.5839L14.0446 15.3744C15.1888 14.5702 16.7369 14.6634 17.7765 15.599L21 18.5001" stroke="#4263EB" stroke-width="2" stroke-linecap="round"></path> </g></svg>

Deposit Confirmation
</h2>
</div>
<div class="col-12 mt-4">
<div class="card card-plan rounded-4">
<div class="card-header bg-gray-100 rounded-top-4">
<h3 class="card-title">Please confirm your deposit:</h3>
</div>
<div class="card-body">
<div class="row row-cards">
<div class="col-xl-10 col-lg-10 col-md-8 col-sm-6 col-12">
<input id="copyInput" type="text" class="form-control rounded-pill bg-black" value="{$description}" readonly>
</div>
<div class="col-xl-2 col-lg-2 col-md-4 col-sm-6 col-12">
<button id="copyButton" class="btn btn-indigo rounded-pill w-100" aria-label="Button">Copy link</button>
</div>
</div>

<div id="copySuccessAlert" class="alert alert-success d-none bg-transparent mt-1" role="alert">
Company wallet address copied to clipboard!
</div>
{literal}
<script>
        document.getElementById('copyButton').addEventListener('click', function () {
          var inputElement = document.getElementById('copyInput');
          var inputValue = inputElement.value;
          copyToClipboard(inputValue);
        });

        function copyToClipboard(text) {
          var tempInput = document.createElement('input');
          tempInput.value = text;
          document.body.appendChild(tempInput);
          tempInput.select();
          document.execCommand('copy');
          document.body.removeChild(tempInput);

          var copySuccessAlert = document.getElementById('copySuccessAlert');
          copySuccessAlert.classList.remove('d-none');

          setTimeout(function () {
            copySuccessAlert.classList.add('d-none');
          }, 2000);
        }
      </script>
{/literal}      
</div>
</div>
</div>


<div class="col-12">
<div class="card rounded-4 border-0">
<div class="card-body">

{if $ok == 1}


<br><br>
<div class="table-responsive">
<table cellspacing=0 cellpadding=2 class="table table-bordered">
{if $deposit.id > 0}
<tr>
 <th>Plan:</th>
 <td>{$deposit.name|escape:html}</td>
</tr>
<tr>
 <th>Profit:</th>
 <td>{$deposit.percent}% {if $deposit.period == 'end' || $deposit.period == 'endh'}after {$deposit.periods} {$deposit.time_units}{if $deposit.periods != 1}s{/if}{else}{$deposit.period_name} for {if $deposit.periods == 0}lifelong{else}{$deposit.periods} {$deposit.time_units}{if $deposit.periods != 1}s{/if} {if $deposit.work_week}(mon-fri){/if}{/if}{/if}</td>
</tr>
<tr>
 <th>Principal Return:</th>
 <td>{if $deposit.principal_return}Yes{if $deposit.principal_return_hold_percent > 0}, with {$deposit.principal_return_hold_percent|number_format:2}% fee{/if}{else}No (included in profit){/if}</td>
</tr>
<tr>
 <th>Principal Withdraw:</th>
 <td>
{if $deposit.principal_withdraw}Available with 
{foreach from=$deposit.principal_withdraw_terms item=t name=wpt}
{$t.percent}% fee {if $t.duration > 0}after {$t.duration} days{/if}{if !$smarty.foreach.wpt.last} or {/if}
{/foreach}
{if $deposit.principal_withdraw_duration_max} but before {$deposit.principal_withdraw_duration_max|number_format} days{/if}
{else}Not available{/if}
 </td>
</tr>
{if $deposit.use_compound == 1}
<tr>
 <th>Compound:</th>
 <td>{$deposit.compound|number_format}%</td>
</tr>
{/if}
{/if} {* $deposit.id *}
{if $deposit.ec_fees.fee}
<tr>
 <th>Credit Amount:</th>
 <td>{$currency_sign}{$deposit.user_amount}</td>
</tr>
<tr>
 <th>Deposit Fee:</th>
 <td>{$deposit.ec_fees.percent}% + {$currency_sign}{$deposit.ec_fees.add_amount} (min. {$currency_sign}{$deposit.ec_fees.fee_min} max. {$currency_sign}{$deposit.ec_fees.fee_max})</td>
</tr>
{/if}
{if $deposit.converted_amount}
<tr>
 <th>Debit Amount:</th>
 <td>{$currency_sign}{$deposit.converted_amount}</td>
</tr>
<tr>
 <th>{$deposit.converted_fiat} Debit Amount:</th>
 <td>{$deposit.amount}</td>
</tr>
{else}
<tr>
 <th>Debit Amount:</th>
 <td>{$currency_sign}{$deposit.amount}</td>
</tr>
{/if}
</table>
<br><br>
<form name=spend method=post>
<input type=hidden name=a value=deposit>
<input type=hidden name=action value=confirm>
<input type=hidden name=type value={$type}>
<input type=hidden name=h_id value={$h_id}>
<input type=hidden name=compound value={$compound}>
<INPUT type=hidden name=amount value="{$famount}">
{if $fields}
<table cellspacing=0 cellpadding=2 border=0 class="table table-bordered">
<tr>
 <td colspan=2><b>Required Information:</b></td>
</tr>
{section name=f loop=$fields}
<tr>
 <td>{$fields[f].name}</td>
 <td><input type="text" name="fields[{$fields[f].id}]" value="" class=inpts></td>
</tr>
{/section}
</table>
{/if}

<br><input type=submit value="Save" class="btn btn-indigo rounded-pill"> &nbsp;
<input type=button class="btn btn-indigo rounded-pill" value="Cancel" onclick="document.location='?a=deposit'">
</form>

{else}

{if $max_deposit_less == 1}
Sorry, the maximal deposit is {$max_deposit_format}.<br>
{/if} 
{if $wrong_paln == 1} The Plan does not exist. {/if} 
{if $not_enough_funds == 1} You have not enough funds to complete the operation.<br>{/if}
{if $less_than_min == 1}
The minimal spend amount for '{$plan_name}' is {$currency_sign}{$min_amount}.<br>
{/if}
{if $zero_amount}
You should enter amount grater than zero.<br>
{/if}

<br>
Click <a href="?a=deposit">here</a> and try again.


{/if}
</div>
</div>
</div>
</div>
{include file="footer.tpl"}
